<?php
require_once __DIR__ . '/config/config.php';
require_once __DIR__ . '/includes/functions.php';

// Check if user is logged in
if (!isLoggedIn()) {
    header('Location: /login.php');
    exit;
}

// Get order ID
$orderId = $_GET['order'] ?? 0;

if (!$orderId) {
    header('Location: /dashboard.php');
    exit;
}

// Get order details
$order = getOrderById($orderId);

if (!$order || $order['user_id'] != $_SESSION['user_id']) {
    header('Location: /dashboard.php');
    exit;
}

// Check if order is already paid
if ($order['status'] === 'paid') {
    header('Location: /dashboard.php');
    exit;
}

// Prepare payment data for Iran server
$paymentData = [
    'action' => 'create_payment',
    'order_id' => $orderId,
    'amount' => (int)$order['price_irr'],
    'description' => 'خرید ' . $order['package_name'],
    'email' => $_SESSION['email'],
    'mobile' => $_SESSION['mobile'],
    'callback_url' => SITE_URL . '/proxy-callback.php'
];

// Send request to Iran server
$ch = curl_init(IRAN_SERVER_URL);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($paymentData));
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Content-Type: application/json',
    'Accept: application/json'
]);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
curl_setopt($ch, CURLOPT_TIMEOUT, 30);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$curlError = curl_error($ch);
curl_close($ch);

$pageTitle = 'انتقال به درگاه پرداخت';
include __DIR__ . '/includes/header.php';
?>

<style>
.payment-container {
    max-width: 600px;
    margin: 50px auto;
    background: white;
    border-radius: 15px;
    padding: 40px;
    box-shadow: 0 5px 25px rgba(0, 0, 0, 0.1);
    text-align: center;
}

.payment-icon {
    font-size: 80px;
    margin-bottom: 20px;
}

.payment-icon.loading {
    color: #667eea;
    animation: spin 2s linear infinite;
}

.payment-icon.success {
    color: #28a745;
}

.payment-icon.error {
    color: #dc3545;
}

@keyframes spin {
    0% { transform: rotate(0deg); }
    100% { transform: rotate(360deg); }
}

.payment-message {
    margin: 20px 0;
    font-size: 18px;
    color: #333;
}

.payment-details {
    background: #f8f9fa;
    padding: 20px;
    border-radius: 10px;
    margin: 20px 0;
    text-align: right;
}

.payment-details p {
    margin: 10px 0;
    color: #666;
}

.btn {
    display: inline-block;
    padding: 12px 30px;
    background: #667eea;
    color: white;
    text-decoration: none;
    border-radius: 8px;
    margin-top: 20px;
    transition: background 0.3s;
}

.btn:hover {
    background: #5568d3;
}

.error-box {
    background: #fee;
    border: 1px solid #fcc;
    color: #c33;
    padding: 20px;
    border-radius: 8px;
    margin: 20px 0;
}

.debug-info {
    background: #f0f0f0;
    padding: 15px;
    border-radius: 6px;
    margin: 20px 0;
    text-align: right;
    font-size: 12px;
    color: #666;
    max-height: 300px;
    overflow-y: auto;
}
</style>

<div class="container">
    <div class="payment-container">
        <?php if ($httpCode === 200 && $response): 
            $responseData = json_decode($response, true);
            
            if ($responseData && $responseData['status'] === 'success' && isset($responseData['payment_url'])): 
                // Save authority to order
                if (isset($responseData['authority'])) {
                    updateOrderStatus($orderId, 'pending', ['authority' => $responseData['authority']]);
                }
        ?>
                <div class="payment-icon success">
                    <i class="fas fa-check-circle"></i>
                </div>
                <h2>درخواست پرداخت موفق</h2>
                <p class="payment-message">در حال انتقال به درگاه پرداخت زرین‌پال...</p>
                
                <div class="payment-details">
                    <p><strong>شماره سفارش:</strong> <?php echo $orderId; ?></p>
                    <p><strong>مبلغ:</strong> <?php echo formatPrice($order['price_irr']); ?> تومان</p>
                    <p><strong>بسته:</strong> <?php echo htmlspecialchars($order['package_name']); ?></p>
                </div>

                <script>
                    // Auto redirect to payment gateway
                    setTimeout(function() {
                        window.location.href = '<?php echo $responseData['payment_url']; ?>';
                    }, 2000);
                </script>

                <p style="color: #999; font-size: 14px; margin-top: 20px;">
                    اگر به صورت خودکار منتقل نشدید، روی دکمه زیر کلیک کنید:
                </p>
                <a href="<?php echo $responseData['payment_url']; ?>" class="btn">
                    <i class="fas fa-credit-card"></i>
                    انتقال به درگاه پرداخت
                </a>

        <?php else: ?>
                <div class="payment-icon error">
                    <i class="fas fa-times-circle"></i>
                </div>
                <h2>خطا در ایجاد درخواست پرداخت</h2>
                
                <div class="error-box">
                    <i class="fas fa-exclamation-triangle"></i>
                    <?php 
                    if ($responseData && isset($responseData['message'])) {
                        echo htmlspecialchars($responseData['message']);
                    } else {
                        echo 'پاسخ نامعتبر از سرور پرداخت';
                    }
                    ?>
                </div>

                <a href="/checkout.php?package=<?php echo urlencode($order['package_code']); ?>&country=<?php echo urlencode($order['country_code']); ?>" class="btn">
                    <i class="fas fa-redo"></i>
                    تلاش مجدد
                </a>

                <div class="debug-info">
                    <strong>اطلاعات خطا:</strong><br>
                    HTTP Code: <?php echo $httpCode; ?><br>
                    Response: <?php echo htmlspecialchars(substr($response, 0, 500)); ?>
                </div>
        <?php endif; ?>

        <?php else: ?>
                <div class="payment-icon error">
                    <i class="fas fa-times-circle"></i>
                </div>
                <h2>خطا در اتصال به سرور پرداخت</h2>
                
                <div class="error-box">
                    <i class="fas fa-exclamation-triangle"></i>
                    امکان اتصال به سرور پرداخت وجود ندارد. لطفاً دوباره تلاش کنید.
                </div>

                <a href="/dashboard.php" class="btn">
                    <i class="fas fa-home"></i>
                    بازگشت به داشبورد
                </a>

                <div class="debug-info">
                    <strong>اطلاعات خطا:</strong><br>
                    HTTP Code: <?php echo $httpCode; ?><br>
                    cURL Error: <?php echo htmlspecialchars($curlError); ?><br>
                    Server URL: <?php echo IRAN_SERVER_URL; ?>
                </div>
        <?php endif; ?>
    </div>
</div>

<?php include __DIR__ . '/includes/footer.php'; ?>

