<?php
/**
 * نمایش کدهای OTP ارسال شده (حالت تست)
 */

$logFile = __DIR__ . '/otp-logs.txt';

?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>لاگ کدهای OTP</title>
    <style>
        body {
            font-family: 'Vazirmatn', Tahoma, Arial, sans-serif;
            background: #f5f5f5;
            padding: 20px;
            direction: rtl;
        }
        .container {
            max-width: 900px;
            margin: 0 auto;
            background: white;
            border-radius: 15px;
            padding: 30px;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
        }
        h1 {
            color: #667eea;
            border-bottom: 3px solid #667eea;
            padding-bottom: 15px;
            margin-bottom: 25px;
        }
        .alert {
            padding: 15px 20px;
            border-radius: 10px;
            margin-bottom: 20px;
        }
        .alert-info {
            background: #e7f3ff;
            color: #0066cc;
            border: 1px solid #b3d9ff;
        }
        .alert-warning {
            background: #fff3cd;
            color: #856404;
            border: 1px solid #ffeaa7;
        }
        .log-entry {
            background: #f8f9fa;
            padding: 15px;
            border-radius: 8px;
            margin-bottom: 10px;
            font-family: 'Courier New', monospace;
            border-left: 4px solid #667eea;
        }
        .log-entry.highlight {
            background: #fff3cd;
            border-left-color: #ffc107;
        }
        .code {
            font-size: 1.5rem;
            font-weight: bold;
            color: #28a745;
            background: white;
            padding: 5px 15px;
            border-radius: 5px;
            display: inline-block;
            margin: 5px 0;
        }
        .mobile {
            color: #667eea;
            font-weight: bold;
        }
        .time {
            color: #666;
            font-size: 0.9rem;
        }
        .btn {
            padding: 12px 25px;
            border: none;
            border-radius: 8px;
            font-size: 1rem;
            cursor: pointer;
            text-decoration: none;
            display: inline-block;
            margin: 5px;
            font-family: 'Vazirmatn', Tahoma, Arial, sans-serif;
        }
        .btn-primary {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
        }
        .btn-danger {
            background: #dc3545;
            color: white;
        }
        .btn-success {
            background: #28a745;
            color: white;
        }
        .empty {
            text-align: center;
            padding: 40px;
            color: #999;
        }
        .stats {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 15px;
            margin-bottom: 25px;
        }
        .stat-box {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 20px;
            border-radius: 10px;
            text-align: center;
        }
        .stat-box h3 {
            margin: 0 0 10px 0;
            font-size: 2rem;
        }
        .stat-box p {
            margin: 0;
            opacity: 0.9;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>📱 لاگ کدهای OTP (حالت تست)</h1>
        
        <div class="alert alert-info">
            <strong>ℹ️ توجه:</strong> این صفحه فقط در حالت تست کار می‌کند. کدهای OTP ارسال شده در اینجا نمایش داده می‌شوند.
        </div>
        
        <?php if (file_exists($logFile)): ?>
            <?php
            $logs = file($logFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
            $logs = array_reverse($logs); // جدیدترین‌ها اول
            $totalLogs = count($logs);
            
            // آخرین کد
            $lastLog = $logs[0] ?? null;
            ?>
            
            <div class="stats">
                <div class="stat-box">
                    <h3><?php echo $totalLogs; ?></h3>
                    <p>کل کدهای ارسال شده</p>
                </div>
                <div class="stat-box">
                    <h3><?php echo date('H:i:s'); ?></h3>
                    <p>زمان فعلی</p>
                </div>
            </div>
            
            <div style="margin-bottom: 20px;">
                <a href="?refresh=1" class="btn btn-primary">🔄 بازخوانی</a>
                <a href="?clear=1" class="btn btn-danger" onclick="return confirm('آیا مطمئن هستید؟')">🗑️ پاک کردن لاگ‌ها</a>
                <a href="login.php" class="btn btn-success">🔐 رفتن به صفحه لاگین</a>
            </div>
            
            <?php
            // پاک کردن لاگ‌ها
            if (isset($_GET['clear'])) {
                unlink($logFile);
                echo '<div class="alert alert-info">✅ لاگ‌ها پاک شدند. <a href="view-otp-logs.php">بازخوانی</a></div>';
                exit;
            }
            ?>
            
            <h2>📋 آخرین کدهای ارسال شده:</h2>
            
            <?php foreach (array_slice($logs, 0, 20) as $index => $log): ?>
                <?php
                // پارس کردن لاگ
                // Format: 2024-01-01 12:00:00 - Mobile: 09123456789 - Code: 123456
                preg_match('/^(.+?) - Mobile: (.+?) - Code: (.+?)$/', $log, $matches);
                
                if (count($matches) >= 4) {
                    $time = $matches[1];
                    $mobile = $matches[2];
                    $code = $matches[3];
                    $isRecent = $index < 3; // 3 تای اول را هایلایت کن
                    ?>
                    <div class="log-entry <?php echo $isRecent ? 'highlight' : ''; ?>">
                        <div class="time">⏰ <?php echo $time; ?></div>
                        <div>
                            📱 موبایل: <span class="mobile"><?php echo htmlspecialchars($mobile); ?></span>
                        </div>
                        <div>
                            🔑 کد تایید: <span class="code"><?php echo htmlspecialchars($code); ?></span>
                        </div>
                        <?php if ($isRecent): ?>
                            <div style="margin-top: 10px; color: #856404;">
                                <strong>⭐ جدید</strong>
                            </div>
                        <?php endif; ?>
                    </div>
                <?php } ?>
            <?php endforeach; ?>
            
            <?php if ($totalLogs > 20): ?>
                <div class="alert alert-info">
                    نمایش 20 کد از <?php echo $totalLogs; ?> کد
                </div>
            <?php endif; ?>
            
        <?php else: ?>
            <div class="empty">
                <h2>📭</h2>
                <p>هنوز کدی ارسال نشده است</p>
                <p style="margin-top: 20px;">
                    <a href="login.php" class="btn btn-primary">رفتن به صفحه لاگین</a>
                </p>
            </div>
        <?php endif; ?>
        
        <div class="alert alert-warning" style="margin-top: 30px;">
            <strong>⚠️ نکته امنیتی:</strong> این صفحه فقط برای تست است. در محیط واقعی، این فایل را حذف کنید یا با رمز عبور محافظت کنید.
        </div>
    </div>
</body>
</html>

